<?php
session_start();
include 'connect.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

$car_id = $_GET['car_id'] ?? '';
$car_query = "SELECT * FROM cars WHERE id = ?";
$stmt = $conn->prepare($car_query);
$stmt->bind_param("i", $car_id);
$stmt->execute();
$car_result = $stmt->get_result();
$car = $car_result->fetch_assoc();
$stmt->close();

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $user_id = $_SESSION['user_id'];
    $fullname = $conn->real_escape_string($_POST['fullname']);
    $car_id = $_POST['car_id'];
    $driver_license = $conn->real_escape_string($_POST['driver_license']);
    $national_id = $conn->real_escape_string($_POST['national_id']);
    $rental_duration = $conn->real_escape_string($_POST['rental_duration']);
    $booking_date = $conn->real_escape_string($_POST['booking_date']);
    $delivery_date = $conn->real_escape_string($_POST['delivery_date']);

    // Calculate total price
    $car_price_query = "SELECT car_price FROM cars WHERE id = ?";
    $stmt = $conn->prepare($car_price_query);
    $stmt->bind_param("i", $car_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $car_price = $result->fetch_assoc()['car_price'];
    $stmt->close();

    $booking_date_obj = new DateTime($booking_date);
    $delivery_date_obj = new DateTime($delivery_date);
    $days = $booking_date_obj->diff($delivery_date_obj)->days + 1;
    $total_price = $car_price * $days;

    $stmt = $conn->prepare("INSERT INTO orders (user_id, fullname, car_id, driver_license, national_id, rental_duration, booking_date, delivery_date, total_price) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("isisssssi", $user_id, $fullname, $car_id, $driver_license, $national_id, $rental_duration, $booking_date, $delivery_date, $total_price);

    if ($stmt->execute()) {
        header("Location: order_tracking.php");
        exit();
    } else {
        $error = "حدث خطأ أثناء إنشاء الطلب.";
    }
    $stmt->close();
}

?>

<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>تعبئة بيانات الحجز</title>
    <link rel="stylesheet" href="styles.css">
</head>
<body>
    <header>
        <h1>تعبئة بيانات الحجز</h1>
    </header>
    <main>
        <section class="booking-form">
            <h2>معلومات الحجز</h2>
            <?php if(isset($error)): ?>
                <p style="color: red;"><?= $error ?></p>
            <?php endif; ?>
            <form action="booking.php" method="post">
                <input type="hidden" name="car_id" value="<?= $car_id ?>">
                
                <label for="fullname">الاسم الكامل:</label>
                <input type="text" id="fullname" name="fullname" required>
                
                <label for="driver_license">رخصة القيادة:</label>
                <input type="text" id="driver_license" name="driver_license" required minlength="10">
                
                <label for="national_id">رقم الهوية الوطنية:</label>
                <input type="text" id="national_id" name="national_id" required minlength="10" maxlength="10">
                
                <label for="rental_duration">مدة الحجز:</label>
                <select id="rental_duration" name="rental_duration" required>
                    <option value="">اختر مدة الحجز</option>
                    <option value="Daily">يومي</option>
                    <option value="Monthly">شهري</option>
                    <option value="Yearly">سنوي</option>
                </select>
                
                <label for="booking_date">تاريخ الحجز:</label>
                <input type="date" id="booking_date" name="booking_date" required>
                
                <label for="delivery_date">تاريخ التسليم:</label>
                <input type="date" id="delivery_date" name="delivery_date" required>
                
                <button type="submit">إرسال</button>
            </form>
        </section>
    </main>
    <script src="booking_script.js"></script>
</body>
</html>