document.addEventListener('DOMContentLoaded', function() {
    const rentalDurationInput = document.getElementById('rental_duration');
    const bookingDateInput = document.getElementById('booking_date');
    const deliveryDateInput = document.getElementById('delivery_date');

    const today = new Date().toISOString().split('T')[0];
    bookingDateInput.value = today;
    bookingDateInput.min = today;

    rentalDurationInput.addEventListener('change', function() {
        const selectedDuration = this.value;
        const selectedBookingDate = new Date(bookingDateInput.value);
        const maxDeliveryDate = new Date(selectedBookingDate);

        switch (selectedDuration) {
            case 'Daily':
                maxDeliveryDate.setDate(selectedBookingDate.getDate() + 29);
                break;
            case 'Monthly':
                maxDeliveryDate.setMonth(selectedBookingDate.getMonth() + 11);
                break;
            case 'Yearly':
                maxDeliveryDate.setFullYear(selectedBookingDate.getFullYear() + 2);
                break;
        }

        deliveryDateInput.max = maxDeliveryDate.toISOString().split('T')[0];
    });

    bookingDateInput.addEventListener('change', function() {
        const selectedDate = new Date(this.value);
        const today = new Date();

        if (selectedDate < today) {
            alert("لا يمكن حجز تاريخ ماضي.");
            this.value = today.toISOString().split('T')[0];
        }
        
        deliveryDateInput.min = this.value;
    });

    deliveryDateInput.addEventListener('change', function() {
        const selectedDeliveryDate = new Date(this.value);
        const selectedBookingDate = new Date(bookingDateInput.value);

        if (selectedDeliveryDate < selectedBookingDate) {
            alert("تاريخ التسليم لا يمكن أن يكون قبل تاريخ الحجز.");
            this.value = '';
        }
    });
});