<?php
session_start();
include 'connect.php';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $username = $conn->real_escape_string($_POST['username']);
    $email = $conn->real_escape_string($_POST['email']);
    $password = $_POST['password'];

    if (strlen($username) > 50 || strlen($email) > 50 || strlen($password) < 8 || strlen($password) > 50) {
        $error = "يرجى التأكد من صحة البيانات المدخلة";
    } else {
        $stmt = $conn->prepare("SELECT id FROM users WHERE username = ? OR email = ?");
        $stmt->bind_param("ss", $username, $email);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows > 0) {
            $error = "اسم المستخدم أو البريد الإلكتروني مستخدم بالفعل";
        } else {
            $stmt = $conn->prepare("INSERT INTO users (username, email, password) VALUES (?, ?, ?)");
            $stmt->bind_param("sss", $username, $email, $password);
            
            if ($stmt->execute()) {
                $_SESSION['user_id'] = $stmt->insert_id;
                $_SESSION['username'] = $username;
                $_SESSION['is_admin'] = false;
                header("Location: index.php");
                exit();
            } else {
                $error = "حدث خطأ أثناء التسجيل";
            }
        }
        $stmt->close();
    }
}
?>

<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>التسجيل</title>
    <link rel="stylesheet" href="styles.css">
</head>
<body>
    <header>
        <h1>التسجيل</h1>
    </header>
    <main>
        <section class="register-form">
            <?php if(isset($error)): ?>
                <p style="color: red;"><?= $error ?></p>
            <?php endif; ?>
            <form action="register.php" method="post">
                <label for="username">اسم المستخدم:</label>
                <input type="text" id="username" name="username" required maxlength="50">
                
                <label for="email">البريد الإلكتروني:</label>
                <input type="email" id="email" name="email" required maxlength="50">
                
                <label for="password">كلمة المرور:</label>
                <input type="password" id="password" name="password" required minlength="8" maxlength="50">
                
                <button type="submit">التسجيل</button>
            </form>
            <p>لديك حساب بالفعل؟ <a href="login.php">تسجيل الدخول</a></p>
        </section>
    </main>
</body>
</html>