<?php
// Include the database connection file
include 'connect.php';

// Enable error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Check if form is submitted
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Collect form data with sanitization
    $fullname = $conn->real_escape_string(trim($_POST['fullname']));
    $phone = $conn->real_escape_string(trim($_POST['phone']));
    $nationalid = $conn->real_escape_string(trim($_POST['nationalid']));
    $email = $conn->real_escape_string(trim($_POST['email']));
    $carmodel = $conn->real_escape_string(trim($_POST['carmodel']));
    $rentalduration = $conn->real_escape_string(trim($_POST['rentalduration']));
    $bookingdate = $conn->real_escape_string(trim($_POST['bookingdate']));
    $deliverydate = $conn->real_escape_string(trim($_POST['deliverydate']));

    // Prepare SQL query using prepared statements to prevent SQL injection
    $stmt = $conn->prepare("INSERT INTO test (fullname, phone, nationalid, email, carmodel, rentalduration, bookingdate, deliverydate) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");

    // Bind parameters
    $stmt->bind_param("ssssssss", $fullname, $phone, $nationalid, $email, $carmodel, $rentalduration, $bookingdate, $deliverydate);

    // Execute query and check for success
    if ($stmt->execute()) {
        echo "New record created successfully";
    } else {
        echo "Error: " . $stmt->error;
    }

    // Close statement
    $stmt->close();
}

// Close connection
$conn->close();
?>
