<?php
session_start(); // بدء جلسة جديدة أو استئناف الجلسة الحالية. تُستخدم الجلسات لتخزين معلومات المستخدم عبر الصفحات
include 'connect.php'; // تضمين ملف الاتصال بقاعدة البيانات. هذا الملف يحتوي على تفاصيل الاتصال بقاعدة البيانات

$query = "SELECT * FROM cars"; // تعريف استعلام لجلب جميع السجلات من جدول السيارات
$result = $conn->query($query); // تنفيذ الاستعلام وتخزين النتيجة في المتغير $result
?>

<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8"> <!-- لدعم النصوص العربية -->
    <meta name="viewport" content="width=device-width, initial-scale=1.0"> <!-- لضمان أن الصفحة متجاوبة مع جميع الأجهزة -->
    <title>تأجير سيارات</title> <!-- عنوان الصفحة الذي يظهر في شريط العنوان للمتصفح -->
    <link rel="stylesheet" href="styles.css"> <!-- تضمين ملف الأنماط لتنسيق الصفحة -->
</head>
<body>
    <header>
        <h1>تأجير سيارات</h1> <!-- العنوان الرئيسي للصفحة -->
        <nav>
            <?php if(isset($_SESSION['user_id'])): ?> <!-- التحقق مما إذا كان المستخدم مسجل الدخول -->
                <?php if($_SESSION['is_admin']): ?> <!-- التحقق مما إذا كان المستخدم لديه صلاحيات المدير -->
                    <a href="admin_dashboard.php">لوحة التحكم</a> <!-- رابط إلى لوحة تحكم المدير -->
                <?php endif; ?>
                <a href="logout.php">تسجيل الخروج</a> <!-- رابط لتسجيل الخروج من الجلسة -->
                <a href="order_tracking.php">تتبع الطلب</a> <!-- رابط لتتبع الطلبات الخاصة بالمستخدم -->
            <?php else: ?>
                <a href="login.php">تسجيل الدخول</a> <!-- رابط لصفحة تسجيل الدخول إذا لم يكن المستخدم مسجل الدخول -->
                <a href="register.php">التسجيل</a> <!-- رابط لصفحة التسجيل للمستخدمين الجدد -->
            <?php endif; ?>
            <a href="#contact">اتصل بنا</a> <!-- رابط لقسم الاتصال في الصفحة -->
            <a href="#about">من نحن</a> <!-- رابط لقسم "من نحن" في الصفحة -->
        </nav>
    </header>
    <main>
        <section class="car-list">
            <?php while($car = $result->fetch_assoc()): ?> <!-- حلقة لجلب كل سيارة من قاعدة البيانات وعرضها -->
            <article class="car-item">
                <!-- لضمان عرض الصور المخزنة في قاعدة البيانات مباشرةً -->
                <img src="data:image/jpeg;base64,<?= base64_encode($car['car_image']) ?>" alt="<?= $car['car_name'] ?> <?= $car['car_model'] ?>">
                <h2><?= $car['car_name'] ?> <?= $car['car_model'] ?></h2> <!-- عرض اسم وموديل السيارة -->
                <p>
                    لمزيد من التفاصيل حول هذه المركبة، انقر  
                    <span class="details-toggle" style="cursor: pointer; color: blue; text-decoration: underline;">هنا</span>
                </p>
                <div class="details" style="display: none;">
                    <p>السعر: $<?= $car['car_price'] ?> في اليوم</p> <!-- عرض سعر تأجير السيارة لليوم الواحد بمتغير car_price -->

                    <?php
                    // إعداد استعلام لجلب مواصفات السيارة بناءً على معرف السيارة car_id
                    $spec_query = "SELECT * FROM car_specifications WHERE car_id = ?";
                    $spec_stmt = $conn->prepare($spec_query); // تحضير الاستعلام 
                    $spec_stmt->bind_param("i", $car['id']); // ربط المعرف الخاص بالسيارة مع الاستعلام
                    $spec_stmt->execute(); // تنفيذ الاستعلام
                    $spec_result = $spec_stmt->get_result(); // الحصول على نتيجة الاستعلام
                    while($spec = $spec_result->fetch_assoc()): // حلقة لعرض كل مواصفة للسيارة تتحدث باستمرار
                    ?>
                        <p><?= $spec['specification'] ?> 
                            <!--  ✓ واذا توفرت X بناءً على توفر الميزة في السيارةاذا لم تتوفر. -->
                            <span class="<?= $spec['has_feature'] ? 'check-icon' : 'check-icon-false' ?>">
                                <?= $spec['has_feature'] ? '✓' : 'X' ?>
                            </span>
                        </p>
                    <?php endwhile; ?>

                </div>
                <?php if($car['quantity'] > 0): ?> <!-- التحقق من توفر السيارة للحجز. -->
                    <a href="booking.php?car_id=<?= $car['id'] ?>" class="button">احجز الآن</a> <!-- رابط لحجز السيارة إذا كانت متوفرة. -->
                <?php else: ?>
                    <p class="out-of-stock">نفذت الكمية</p> <!-- رسالة تفيد بنفاد الكمية إذا لم تكن السيارة متوفرة للحجز. -->
                <?php endif; ?>
            </article>
            <?php endwhile; ?>
        </section>
    </main>
    <script src="script.js"></script> <!-- تضمين ملف جافا سكريبت لسلاسة الحركة والتفاعلات الديناميكية في الصفحة -->
</body>
</html>