<?php
session_start();
include 'connect.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

$user_id = $_SESSION['user_id'];
$orders_query = "SELECT orders.*, cars.car_name, cars.car_model 
                 FROM orders 
                 JOIN cars ON orders.car_id = cars.id 
                 WHERE orders.user_id = ?";
$stmt = $conn->prepare($orders_query);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$orders_result = $stmt->get_result();
?>

<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>تتبع الطلبات</title>
    <link rel="stylesheet" href="styles.css">
</head>
<body>
    <header>
        <h1>تتبع الطلبات</h1>
        <nav>
            <a href="index.php">الصفحة الرئيسية</a>
            <a href="logout.php">تسجيل الخروج</a>
        </nav>
    </header>
    <main>
        <section class="order-tracking">
            <h2>طلباتك</h2>
            <?php if ($orders_result->num_rows > 0): ?>
                <table>
                    <thead>
                        <tr>
                            <th>رقم الطلب</th>
                            <th>السيارة</th>
                            <th>تاريخ الحجز</th>
                            <th>تاريخ التسليم</th>
                            <th>السعر الإجمالي</th>
                            <th>الحالة</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php while($order = $orders_result->fetch_assoc()): ?>
                        <tr>
                            <td><?= $order['id'] ?></td>
                            <td><?= $order['car_name'] ?> <?= $order['car_model'] ?></td>
                            <td><?= $order['booking_date'] ?></td>
                            <td><?= $order['delivery_date'] ?></td>
                            <td><?= $order['total_price'] ?> ريال</td>
                            <td>
                                <?php
                                switch ($order['status']) {
                                    case 'Approved':
                                        echo '<span style="color: green;">مقبول</span>';
                                        break;
                                    case 'Declined':
                                        echo '<span style="color: red;">مرفوض</span>';
                                        break;
                                    default:
                                        echo 'قيد الانتظار';
                                }
                                ?>
                            </td>
                        </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            <?php else: ?>
                <p>لا توجد طلبات حالية.</p>
            <?php endif; ?>
        </section>
    </main>
</body>
</html>